
jQuery(document).ready(function(){
	if(OcAjax){
		jQuery('#oc-chat-container').onlineChat(OcAjax);
		
	}

});

(function( $ ){
	
  var $titleBar, $audio, $chatBox, $userBox, $chatWrapper, $chatInput, $chatInputWrapper, $chatSend, $chatList, $userList, $backBtn, $userForm, settings, data, activeChatId, activeChatType, chatMessages, onlineUsers, pinging = false, pingComplete = true, messageComplete = true, boxWidth, chatIsOpen, pingCount = 0, lastMessageId, chatRendered = false, titleText, closedTitleText, serverTime;
  var $chatElements = {
  		container: {},
  		titleBar: {},
  		titleText: {},
  		chatBox: {},
  		userBox: {},
  		chatWrapper: {},
  		chatInput: {},
  		chatInputWrapper: {},
  		chatContent:{},
  		chatSend: {},
  		chatList: {},
  		chatListWrapper: {},
  		userList: {},
  		backBtn: {},
  		userForm: {},
  		adminTitleBar: {}
  }
  var methods = {
    init : function( options ) {
    
		if(chatRendered){
			return false;
		}
    	chatRendered = true;
    	data = $.extend( {
    		'settings' : {},
    		'messages' : [],
      		'options'         : { 
      								'visible': 0,
      								'active': 0
 								}
    	}, options);
    	
    	$chatElements.container = $(this);
    	
    	boxWidth = $chatElements.container.width();
    	chatMessages = data.messages;
    	
    	activeChatId = parseInt(data.options.active);
    	activeChatType = _parseBoolean(data.options.active_is_visitor);
    	
    	chatIsOpen = data.options.visible;
    	onlineUsers = data.users;
    	serverTime = data.settings.time;
    	lastMessageId = data.settings.last_message_id;
    	$chatElements.chatBox = $('#oc-chat-box');
  		$chatElements.userBox = $('#oc-user-box');
	    $chatElements.chatInput = $('<input/>').attr({ type: 'text', id: 'oc-chat-input', name: 'message', tabindex: '-1' });
	    $chatElements.titleBar = $('#oc-title');
	    $chatElements.backBtn = $('#oc-back-btn');
	    $chatElements.chatWrapper = $('#oc-chat-wrapper');
	    $chatElements.chatContent = $('#oc-chat-content');
	    $chatElements.userList = $('#oc-user-list');
	    $chatElements.chatList = $('#oc-message-list');
	    $chatElements.chatListWrapper = $('#oc-chat-message-list-wrapper');
	    $chatElements.chatSend = $('#oc-message-send');
	    $chatElements.titleText = $('#oc-title-text');
	    titleText = $chatElements.titleText.text();
	    
	    if(!!document.createElement('audio').canPlayType &&  _parseBoolean(data.settings.enable_sounds)) {

		 	$audio = $('<audio/>').html('<source src="' + data.settings.uri + 'assets/sounds/alert.ogg" type="audio/ogg"></source><source src="' + data.settings.uri + 'assets/sounds/alert.mp3" type="audio/mpeg"></source>');
		 	$audio.insertAfter($chatElements.container);
		 	$audio.on('play', function(){
		 		this.play();
		 	});
			
		}
		
	    if(_parseBoolean(data.settings.admin_bar)){
	        $chatElements.adminTitleBar = $('#wp-admin-bar-oc-admin-chat-title .ab-item');
	        $chatElements.adminTitleBar.on('click',function(e){
	        	e.stopPropagation();
	        	e.preventDefault();
	    		if($chatElements.container.hasClass('open')){
	    			methods.hide();
	    			 $chatElements.adminTitleBar.parent().removeClass('hover');
	    		} else {
	    			methods.show();
	    			$chatElements.adminTitleBar.parent().addClass('hover');
	    		}
	    		
	    	});
	    	
	    	$chatElements.container.on('click',function(e){
	    		e.stopPropagation();
	    	});
	    	
	    	$('html').on('click',function(e){
	    		if($chatElements.container.hasClass('open')){
	    			methods.hide();
	    			$chatElements.adminTitleBar.parent().removeClass('hover');
	    		}
	    	});
			if(data.options.visible > 0){
				$chatElements.adminTitleBar.parent().addClass('hover');
			
			
			}
    	} else {
    	
    		$chatElements.titleBar.on('click',function(e){
    			e.stopPropagation();
	    		if($chatElements.container.hasClass('open')){
	    			methods.hide();
	    		} else {
	    			methods.show();
	    		}
	    		
	    	});
    	}
    	
    		  $chatElements.backBtn.on('click',function(e){
	    		$(this).addClass('disabled');
	    		e.stopPropagation();
	    		methods.closeChat();
	    		
	    	});
    	
    	
    	_buildUsers();
    	
    	$('#oc-chat-input-wrapper').prepend($chatElements.chatInput);

    	
    	
    	
    	$chatElements.chatInput.keypress(function(e){
    		
    			e.stopPropagation()
      			if(e.which == 13){
       				methods.send();
       		}
      	});
    	$chatElements.chatSend.on('click',function(e){
    		e.stopPropagation()
    		methods.send();
    	
    	});
    	
    	_buildForm();
    	
    	if(data.settings.logged_in){
    		$userActions = $('#oc-user-actions');
    		$userStatus = $('<select/>');
    		var $userWrapper = $('#oc-user-list-wrapper');
    		var statuses = '';
    		var activeStatus=''
    		for(var i=0;i<data.settings.status_list.length;i++){
    			activeStatus = (data.options.user_status == i) ? 'selected="selected"' : '';
    			statuses += '<option value="' + i + '" ' + activeStatus +'>' + data.settings.status_list[i] + '</option>';
    		}
    		$userStatus.html(statuses);
    		$userStatus.on('change keyup',function(e){
    			var newStatus = $(this).val();
    			_post({
					'oc_actions': { status: newStatus + ''}
				});
    		});
    		
    		$userWrapper.height($userWrapper.height()-$userActions.height());
    		$userActions.append($userStatus);
    	}
    	
    	
    	if(!data.settings.enabled){
    		
    	} else {
    		if(activeChatId > 0){
    			
    				$chatElements.backBtn.attr('class','');
    			
    			if(_buildThread(activeChatId,activeChatType)){
    				_scrollChatDown();
    				$('#' + _getUserHtmlId(activeChatId,activeChatType)).addClass('opened');
    				$chatElements.chatWrapper.css({'left' : - (2 * boxWidth)});
    			} else {
    				$chatElements.chatWrapper.css({'left' : - boxWidth});
    			}
    			
    		} else {
    			$chatElements.chatWrapper.css({'left' : - boxWidth});
    		}
    		
    		pinging = setTimeout(_startPing, data.settings.interval);
    	}
    	
    	
    	if(data.options.visible > 0){
    		$chatElements.chatContent.show();
    		$chatElements.container.addClass('open');
    	} else {
    		closedTitleText = $chatElements.titleText.text();
    		$chatElements.titleText.text(titleText);
    		$chatElements.chatContent.hide();
    		$chatElements.titleBar.children('div').hide();
    	}
    	

    },
    openChat : function() {
    	var valid = _buildThread(activeChatId,activeChatType);
    	if(!valid) {
    		return false;
    	
    	}
    	_scrollChatDown();
    	$chatElements.backBtn.attr('class','');
    	$chatElements.chatWrapper.animate({
    		'left' : -(2 * boxWidth)
    	},{
    		easing: 'easeInCirc',
    		duration: 100
    	});
    	_post({
					'oc_options': { 
						active: activeChatId,
						active_is_visitor: activeChatType
					}
				});
    },
    closeChat : function() {
    	//_saveThreadHtml();
    	$chatElements.userList.children('li').removeClass('opened').removeClass('notify');
    	$chatElements.titleText.text(titleText);
    	activeChatId = 0;
    	$chatElements.chatWrapper.animate({
    		'left' : - boxWidth
    	
    	},{
    		easing: 'easeOutCirc',
    		duration: 100
    	});
    	_post({
					'oc_options': { active: 0 }
				});
    },
    show : function( ) {
      $chatElements.titleText.text(closedTitleText);
     
      if(_parseBoolean(data.settings.admin_bar)){
	    	$chatElements.adminTitleBar.parent().removeClass('notify');
      
      } 
      
      $chatElements.titleBar.attr('class','').children('div').show();
      $chatElements.chatContent.slideDown(200,'easeInCirc',function(){
      		 $chatElements.container.addClass('open');
      		_post({
					'oc_options': { visible: 1 }
				});
      });
    },
    hide : function( ) {
    	closedTitleText = $chatElements.titleText.text();
    	$chatElements.titleText.text(titleText);
    
       $chatElements.titleBar.children('div').hide();
       $chatElements.chatContent.slideUp(200,'easeOutCirc', function(){
  			$chatElements.container.removeClass('open');
			_post({
				'oc_options': {visible: 0}
			});
      });
    },
    send : function(){
    	var input = $chatElements.chatInput.val();
    	if(input != ''){
    		$chatElements.chatInput.val('');
    		_newMessage(input,'out');
    	}
    },
    getMessages: function(){
    	pingComplete = false;
    	_post({
					'oc_ping': lastMessageId
				},function(response){
					
					pingComplete = true;
					if(!response) {return false;}
					onlineUsers = response.users;
					
					serverTime = response.settings.time;
					_updateUsers();
					if(response.settings.last_message_id > 0){
						
						_updateMessageCount(response.messages);
						_buildThread();
						lastMessageId = response.settings.last_message_id;
					}
				    
				    
				});
    },
    stopPing: function() {
    	if(pinging){
    		clearInterval(pinging);
    	}
    },
    updateOptions: function() {
    	_post({
					'oc_options': { visible: 1,
									active: activeChatId
								}
				});
    }
    
    
  };
   function _startPing() {    	
    	pinging = setInterval(function(){
    			if(data.settings.ping_limit > 0 && pingCount == data.settings.ping_limit){
    				methods.stopPing();
    			} else {
    				if(pingComplete && messageComplete){
    					pingCount++;
    					methods.getMessages();
    				}
    			}
    		}, data.settings.interval);
    		
    }
  	function _newMessage(message){
    	var $newMessage = $('<li/>').attr({class:'out'}).addClass('pending').html(data.options.gravatar + message);
    	$chatElements.chatList.append($newMessage);
    	
    	_scrollChatDown();
    	
    	var thisChatId = activeChatId;
    	var thisChatType = activeChatType;
    	var messageData = {
					'oc_message': { 
								'last_message_id' : lastMessageId,
								'recipient': thisChatId,
								'is_visitor': thisChatType,
								'message': message
							}
					}
		messageComplete = false;
    	_post( messageData ,function(response){
    				//console.log(response);
    				
					if(!response){
						$newMessage.remove();
						messageComplete = true;
						return false;
					}
					
					var messageId = 'oc-chat-message-' + response.settings.inserted_message_id;
    				
    				if($('#' + messageId).length > 0){
    					$newMessage.remove();
    					return false;
    				}
					$newMessage.attr({
						'id': messageId,
						'class': 'out'
					});
						
					var messageObj = {
						'direction' : 'out',
						'id' : response.settings.inserted_message_id,
						'message' : message,
						'send_time' : response.settings.time
					}
					var newThread = true;
					for(var j=0;j<chatMessages.length;j++){
	    				if(parseInt(chatMessages[j].user.id) == thisChatId && _parseBoolean(chatMessages[j].user.is_visitor) == thisChatType){
	    					chatMessages[j].messages.push(messageObj);
	    					newThread = false;
	    				}
					}
					if(newThread){

						var $userData = $('#' + _getUserHtmlId(thisChatId,thisChatType));
						$userData.addClass('active');
						var threadObj = {
								messages : [ messageObj ],
								user : {}
							}
							
						for(var i=0;i<onlineUsers.length;i++){
						
							if(onlineUsers[i].id == thisChatId && onlineUsers[i].is_visitor === thisChatType){
								threadObj.user = onlineUsers[i];						
								break;
							}
						
						}
						
						chatMessages.push(threadObj);
						
					}
					
    					
						lastMessageId = response.settings.last_message_id;
						messageComplete = true;
				});
    }

  	function _scrollChatDown(){
  		
  		$chatElements.chatListWrapper.scrollTop($chatElements.chatListWrapper[0].scrollHeight);
  	
  	}
  	
  	function _updateMessageCount(newMessages){
  		var userId,userType,htmlId,$link, newCount, oldCount, needsNotify = false;
  	
  		for(var i=0;i<newMessages.length;i++){
  			userID = parseInt(newMessages[i].user['id']);
    		userType = _parseBoolean(newMessages[i].user['is_visitor']);
    		htmlId =  _getUserHtmlId(userID,userType);

    		var $link = $('#' + htmlId);
    		
    		if($link.length > 0){
    			oldCount = parseInt($link.data('messages'));
    			
    			if(oldCount == 0){
    				$link.addClass('active');
    			}
    			
    			newCount = oldCount + newMessages[i].messages.length;

	    		if(oldCount < newCount){
	    			needsNotify = true;
	    			$link.addClass('notify');
	    			if($audio){
	    				$audio.trigger('play');
	    			}
	    		}
    			$link.data('messages', newCount);
    		}
    		var newThread = true;
    		for(var j=0;j<chatMessages.length;j++){
    			if(parseInt(chatMessages[j].user.id) == userID && _parseBoolean(chatMessages[j].user.is_visitor) == userType){
    				newThread = false;
    				for(var k=0;k<newMessages[i].messages.length;k++){
    				
    				
    				chatMessages[j].messages.push(newMessages[i].messages[k]);
    				}
    			}
    		}
    		if(newThread){
    			needsNotify = true;
    			chatMessages.push(newMessages[i]);
    		}
    		
    		if(needsNotify) {
	    		if(!$chatElements.container.hasClass('open')){
					if(_parseBoolean(data.settings.admin_bar)){
						$chatElements.adminTitleBar.parent().addClass('notify');
					} else {
						$chatElements.titleBar.addClass('notify');
					}
		    					
		    	} 
	    	}		
  		}
  	}
    
  	function _parseBoolean(str) {
  		return /^true$/i.test(str);
	}

	function _post(content, callback){
	  var postData = $.extend({action: 'my_action'},content);
      $.ajax({
      	type: 'POST',
      	url: data.settings.ajaxurl,
      	data: postData,
      	success: callback,
      	dataType: 'json'
      	
      });
    }
    function _getUserHtmlId(id,type){
    	var htmlId;
    	if(!type){
    		htmlId = 'oc-user-' + id;
    	} else {
    		htmlId = 'oc-visitor-' + id;
    	}
    	return htmlId;
    }
    
    function _setUserStatus($el,object){
		var stillActive = (data.settings.inactive_limit > (serverTime - object.last_activity)/60);
		var linkClass;
		
		if(object.status != undefined && object.status == 1){
			linkClass = 'online busy';
		} else if(!stillActive) {
			linkClass = 'online away';
		} else {
			linkClass = 'online';
		}
			
		if($el){
			if($el.hasClass('opened')){
				linkClass += " opened";
			}
			if($el.hasClass('active')){
				linkClass += " active";
			}
			if($el.hasClass('notify')){
				linkClass += " notify";
			}
			if($el[0].className != linkClass){
				$el[0].className = linkClass;
			}
		}
		return linkClass;
	}
    function _updateUsers(){
		
    	$chatElements.userList.children('li').addClass('remove');
    	var $newUser,$link,userType,userID,htmlId,country;
    	for(var i=0;i<onlineUsers.length;i++){
    		userID = parseInt(onlineUsers[i]['id']);
    		userType = onlineUsers[i]['is_visitor'];
    		htmlId =  _getUserHtmlId(userID,userType);
    		$link = $('#' + htmlId);
    		
    		if($link.length){
    			$link.removeClass('remove');
    			_setUserStatus($link,onlineUsers[i]);
    			if($link.hasClass('opened')){
    					$('#oc-offline-user-notice').hide();
    			}
    		} else {
    		
	    		if(onlineUsers[i]['country'] != undefined && onlineUsers[i]['country']){
	    			country = '<img class="oc_country" src="' + data.settings.uri + 'css/images/countries/' + onlineUsers[i]['country'].toLowerCase() + '.png"/>';
	    		} else {
	    			country = '';
	    		}
				$newUser = $('<li/>')
	    			.attr({
	    				'id' : _getUserHtmlId(onlineUsers[i]['id'],onlineUsers[i]['is_visitor']),
	    				'data-id' : onlineUsers[i]['id'],
	    				'data-visitor' : onlineUsers[i]['is_visitor'],
	    				'data-messages' : 0
	    			})
	    			.html(onlineUsers[i]['gravatar'] + '<span>' + onlineUsers[i]['display_name'] + '</span>' + country);
	    			_setUserStatus($newUser,onlineUsers[i]);
	    			$chatElements.userList.append($newUser);
	    			$newUser.on('click', activateOpenChat);

    		}
    		
    	}

    	$chatElements.userList.children('li.remove').each(function(){
    		
    		 var $this = $(this);
    		 
    		 if($this.hasClass('active')){
    		 	$this.removeClass('remove').removeClass('online');
    		 	return;
    		 }
    		 
    		 if($this.data('id') === activeChatId && $this.data('visitor') === activeChatType){
    		 	methods.closeChat();
    		 }
    		 
    		 $this.off('click').remove();
    	});
    	if($chatElements.userList.children('li').length < 1){
    		$('#oc-no-users-online-notice').show();
    	} else {
    		$('#oc-no-users-online-notice').hide();
    	}
    }
    function activateOpenChat(){
    		var $this = $(this);
    		 $this.removeClass('notify').addClass('opened');
    		 activeChatId = $this.data('id');
    		 activeChatType = _parseBoolean($this.data('visitor'));
    		 methods.openChat();
    }
    
    function _buildUsers(){
    	var html = '';
    	var country = '';
    	var displayName;
    	for(var i=0;i<chatMessages.length;i++){
    	
    		if(chatMessages[i].user['country'] != undefined && chatMessages[i].user['country']){
    			country = '<img class="oc_country" src="' + data.settings.uri + 'css/images/countries/' + chatMessages[i].user['country'].toLowerCase() + '.png"/>';
    		} else {
    			country = '';
    		}
    		
    		var userID = parseInt(chatMessages[i].user['id']);
    		var userType = chatMessages[i].user['is_visitor'];
    		var htmlId =  _getUserHtmlId(userID,userType);
    		var messageCount = chatMessages[i].messages.length;

    		displayName = (chatMessages[i].user['display_name']) ? chatMessages[i].user['display_name'] : chatMessages[i].user['ip'];
    		
    		html += '<li id="' + htmlId + '" class="active" data-id="'+ userID +'" data-visitor="' + userType + '" data-messages="' + messageCount + '">' + chatMessages[i].user['gravatar'] + '<span>' + displayName + '</span>' + country + '</li>';
    		
    	}
    	$chatElements.userList.html(html);
    	
    	html = '';
    	for(var i=0;i<onlineUsers.length;i++){
    		if(onlineUsers[i]['country'] != undefined && onlineUsers[i]['country']){
    			country = '<img class="oc_country" src="' + data.settings.uri + 'css/images/countries/' + onlineUsers[i]['country'].toLowerCase() + '.png"/>';
    		} else {
    			country = '';
    		}
    		var userID = parseInt(onlineUsers[i]['id']);
    		var userType = onlineUsers[i]['is_visitor'];
    		var htmlId =  _getUserHtmlId(userID,userType);
    		displayName = (onlineUsers[i]['display_name']) ? onlineUsers[i]['display_name'] : onlineUsers[i]['ip'];
    		var $existing = $('#' + htmlId);
    		if($existing.length){
    			$existing.addClass('online');
    			_setUserStatus($existing,onlineUsers[i])
    		} else {
    		var userClass = _setUserStatus(0,onlineUsers[i]);
    		
    		html += '<li id="' + htmlId + '" class="'+ userClass +'" data-id="'+ userID +'" data-visitor="' + userType + '" data-messages="0" >' + onlineUsers[i]['gravatar'] + '<span>' + displayName + '</span>' + country + '</li>';
    		
    		}
    		
    		
    	}
    	var newHtml = $chatElements.userList.html() + html;
    	$chatElements.userList.html(newHtml);
    	if($chatElements.userList.children('li').length < 1){
    		$('#oc-no-users-online-notice').show();
    	} else {
    		$chatElements.userList.children('li.online, li.active').on('click',activateOpenChat);
    	}
    	
    
    }
    
    function _buildThread(id,type){

 	 var needScroll = ($chatElements.chatListWrapper[0].scrollHeight - $chatElements.chatListWrapper[0].scrollTop <= $chatElements.chatListWrapper.height());
 	 var htmlId =  _getUserHtmlId(activeChatId,activeChatType);
 	 var $activeUser = $('#' + htmlId);
 	 if($activeUser.length < 1){
 	 	return false;
 	 } else {
 	 	$chatElements.titleText.text(data.settings.chatting_prefix + $activeUser.children('span').text());
 	 
 	 }
 	 if(!$activeUser.hasClass('online')){
 	 	$('#oc-offline-user-notice').show();
 	 	
 	 } else {
 	 	$('#oc-offline-user-notice').hide();
 	 }
 	 var chatHtml;
    	if(chatMessages.length > 0){
    		for(var i=0; i<chatMessages.length;i++){
    			if(chatMessages[i].user.id == activeChatId && chatMessages[i].user.is_visitor == activeChatType){

    							var html = '';
    							var gravatar;
    							if(chatMessages[i].html != undefined){
    								html = chatMessages[i].html;
    							}
    										
    							for(var j=0;j<chatMessages[i].messages.length;j++){
    								if(chatMessages[i].messages[j].rendered == undefined || chatMessages[i].messages[j].rendered == false){
    									    									
    									if(html.indexOf('#oc-chat-message-' + chatMessages[i].messages[j].id,0) >= 0){
    										chatMessages[i].messages[j].rendered = true;
    									
    									
    									} else {
    										gravatar = (chatMessages[i].messages[j].direction === 'in') ? chatMessages[i].user.gravatar : data.options.gravatar;
    								html += '<li id="oc-chat-message-' + chatMessages[i].messages[j].id +'" class="' + chatMessages[i].messages[j].direction + '">' + gravatar + chatMessages[i].messages[j].message + '</li>';
    								chatMessages[i].messages[j].rendered = true;
    									
    									}
    								
    								}
    							}
								
    							$chatElements.chatList.html(html);
    							chatMessages[i].html = html;
    							if(needScroll){
    								_scrollChatDown();
    							}
    							return true;
    			}
    		}
    	}
    	
    	$chatElements.chatList.html('');
    	return true;    
    }
    
    function validateEmail(email) { 
    	var re = /^(([^<>()[\]\\.,;:\s@\"]+(\.[^<>()[\]\\.,;:\s@\"]+)*)|(\".+\"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
    	return re.test(email);
	}
	
	function _buildForm(){
    	$chatElements.userForm = $('#oc-user-form-fields');
    	var input = '';
    	
    	for(var i=0;i < data.settings.fields.length;i++){
    		switch(data.settings.fields[i].type){
    			
    			default:
    				input += '<input id="oc-user-field-' + data.settings.fields[i].name + '" name="' + data.settings.fields[i].name + '" type="text" placeholder="' + data.settings.fields[i].label + '" data-required="' + data.settings.fields[i].required + '"/>';
    		}
    	}
    	
    	$chatElements.userForm.html(input);
    	$('#oc-user-session-start').on('click', function(e){
    		e.preventDefault();
    		
    		if($(this).hasClass('sending')){
    			return false;
    		}
    		
    		var formValidated = true,
    			userData = {};
    		var $fields = $chatElements.userForm.children('input');
    		
    		for(var i=0;i < $fields.length ;i++){
    			var $field = $($fields[i]);
    			if($field.data('required') && !$field.val()){
    				$field.addClass('warning');
    				formValidated = false;
    			} else {
    				if($field.val() && $field.attr('name') == 'email' && !validateEmail($field.val())){
    					$field.addClass('warning');
    					formValidated = false;
    				} else {
    					userData[$field.attr('name')] = $field.val();
    					$field.attr('class','');
    				}
    			}
    			
    		
    		}
    		
    		if(formValidated){
    			$(this).attr('disabled','disabled').addClass('sending');
    			_post({
					'oc_start': {
						'fields' : userData
					}
				},function(response){
					$('#oc-user-session-start').attr('disabled','').removeClass('sending');
					if(response){
						$chatElements.chatWrapper.animate({
				    		'left' : - boxWidth
				    	},{
				    		easing: 'easeInCirc',
				    		duration: 100
				    	});
					
					}
					data.options = response;
					pinging = setTimeout(_startPing, data.settings.interval);
				
				});
    		}
    	});
    }
    
  $.fn.onlineChat = function( method ) {
    if ( methods[method] ) {
      return methods[ method ].apply( this, Array.prototype.slice.call( arguments, 1 ));
    } else if ( typeof method === 'object' || ! method ) {
      return methods.init.apply( this, arguments );
    } else {
      $.error( 'Method ' +  method + ' does not exist in Online Chat' );
    }    
  
  };

})( jQuery );